import { TestBed, inject } from '@angular/core/testing'

import { ILogMessage,
        UpperCaseFormatProvider,
        JsonFormatProvider,
        BrowserConsoleOutputProvider,
        LogLevel,
        LoggerService } from './logger.service'

import { Config, ConfigService } from '../config/config.service'

describe('LoggerService', () => {
  beforeEach(() => {
    TestBed.configureTestingModule({
      providers: [LoggerService, ConfigService]
    })
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  })

  it('expects one output from LogLevel.Error', inject([LoggerService], (service: LoggerService) => {
    let count = 0
    service.setlogLevel(LogLevel.Error)
    service.setOutputProvider((data: ILogMessage): void => {
      count++
    })
    service.error("(error)")
    service.warn("(warn)")
    service.info("(info)")
    service.debug("(debug)")
    service.debug("(debug)")
    expect(count).toEqual(1)
  }))

  it('expects two outputs from LogLevel.Warn', inject([LoggerService], (service: LoggerService) => {
    let count = 0
    service.setlogLevel(LogLevel.Warn)
    service.setOutputProvider((data: ILogMessage): void => {
      count++
    })
    service.error("(error)")
    service.warn("(warn)")
    service.info("(info)")
    service.debug("(debug)")
    service.debug("(debug)")
    expect(count).toEqual(2)
  }))

  it('expects three outputs from LogLevel.Info', inject([LoggerService], (service: LoggerService) => {
    let count = 0
    service.setlogLevel(LogLevel.Info)
    service.setOutputProvider((data: ILogMessage): void => {
      count++
    })
    service.error("(error)")
    service.warn("(warn)")
    service.info("(info)")
    service.debug("(debug)")
    service.debug("(debug)")
    expect(count).toEqual(3)
  }))

  it('expects five outputs from LogLevel.Debug', inject([LoggerService], (service: LoggerService) => {
    let count = 0
    service.setlogLevel(LogLevel.Debug)
    service.setOutputProvider((data: ILogMessage): void => {
      count++
    })
    service.error("(error)")
    service.warn("(warn)")
    service.info("(info)")
    service.debug("(debug)")
    service.debug("(debug)")
    expect(count).toEqual(5)
  }))

  it('expects UPPERCASE', inject([LoggerService], (service: LoggerService) => {
    service.setlogLevel(LogLevel.Info)
    service.setformatProvider(UpperCaseFormatProvider)
    service.setOutputProvider((data: ILogMessage): void => {
      expect(data.message).toEqual("(INFO)")
    })
    service.info("(info)")
  }))

  it('expects JSON output', inject([LoggerService], (service: LoggerService) => {
    service.setlogLevel(LogLevel.Info)
    service.setformatProvider(JsonFormatProvider)
    service.setOutputProvider((data: ILogMessage): void => {
      // console.log(data.message)
      expect(data.message).toEqual('{"operation":{"add":[2,3]},"answer":5}')
    })
    service.info({ operation: { add: [2, 3] }, answer: 5 })
  }))
})
